<?php

  /**
   * M.1k2 JSON interface demo script
   * 
   * @version 1 (18.03.2013) [FF]
   * @author Florian Faber, florian.faber@directout.eu
   *
   **/

$IP = "192.168.178.45";

error_reporting(E_ALL);


function http_request($server, $url, $request) {
  $fp = fsockopen($server, 80, $errno, $errstr);
  if (!$fp) 
    return false;
  fputs($fp, $request);
  fflush($fp);
  $ret = "";
  while (!feof($fp)) {
    $ret.= fgets($fp, 1024);
  }
  fclose($fp);
  return $ret;
}

function http_get($server, $url) {
  return http_request($server, $url, "GET $url HTTP/1.1\r\nHost: $server\r\n\r\n");
}

function http_post($server, $url, $body) {
  return http_request($server, $url, "POST $url HTTP/1.1\r\nHost: $server\r\nContent-Type: application/json\r\nContent-Length: ".strlen($body)."\r\n\r\n".$body);
}


//
// Get device status
//

echo "*** Get device status\n".http_get($IP, "/json/status_get")."\n\n";


//
// Get all XPs
//

echo "*** Get all XPs\n".http_get($IP, "/json/xps_get")."\n\n";


//
// Set a single XP
//

echo "*** Set single XP\n".http_post($IP, "/json/xps_set", "{\"0\":64}")."\n\n";


//
// Clear a single XP
//

echo "*** Clear single XP\n".http_post($IP, "/json/xps_set", "{\"0\":null}")."\n\n";


//
// Stretching the parsing process a bit
//

echo "*** Teasing the parser\n".http_post($IP, "/json/xps_set", "{\r\n \"47\"\r\n\r\n  \t  :   \n\n\n\n23\r\n\r\n ,\r\n\"48\" :null}")."\n\n";


//
// Syntax errors
//

echo "*** Syntax errors\n\n";

echo http_post($IP, "/json/xps_set", "Foo.")."\n\n";
echo http_post($IP, "/json/xps_set", "{ \"a3\":\"foo\" }")."\n\n";
echo http_post($IP, "/json/xps_set", "{ \"32\":\"foo\" }")."\n\n";


//
// Semantic errors
//

echo "*** Semantic errors\n\n";

echo http_post($IP, "/json/xps_set", "{\"1024\":10}")."\n\n";
echo http_post($IP, "/json/xps_set", "{\"10\":1024}")."\n\n";


//
// Cycling through unity matrix, disconnected matrix and random matrix
//

echo "*** Unity/Disconnected/Random XPs\n\n";

for (;;) {
  $ar = "{";
  for ($i=0; $i<1024; $i++) {
    if ($i>0)
      $ar .= ",";
    $ar .= "\"$i\": $i";
  }
  $ar .= "}";
  
  echo http_post($IP, "/json/xps_set", $ar)."\n\n";

  sleep(1);

  $ar = "{";
  for ($i=0; $i<1024; $i++) {
    if ($i>0)
      $ar .= ",";
    $ar .= "\"$i\": null";
  }
  $ar .= "}";
  
  echo http_post($IP, "/json/xps_set", $ar)."\n\n";

  sleep(1);

  $ar = "{";
  for ($i=0; $i<1024; $i++) {
    if ($i>0)
      $ar .= ",";
    $ar .= "\"$i\": ".rand(0, 1023);
  }
  $ar .= "}";
  
  echo http_post($IP, "/json/xps_set", $ar)."\n\n";
  
  sleep(1);
}


?>